%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate6_Selected.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This file runs the 6 sensor project based on a selected
%                 set of previous results
%--------------------------------------------------------------------------
close all; clear all; clc;
warning('OFF');

SavePlots = true;
numSensors = 6;

% Note: The previous results must be saved in the file 'Results_6.mat'
% mean6 = 1.6225, 53.7402, 1.9700
% Load in all the data that we are choosing from
load Results_6.mat
deltaE_Idx = 2*numSensors + 1;
MTF50_Idx = 2*numSensors + 2;

FindValues = [  1.626 54.2 ;    % Mean
                1.619 54;       % Mean
                1.652 54.6;     % Mean
                2.651 125;      % Best Freq
                1.093 57.4];    % Best color
FindIdx = [];
Tol = 0.0001;

% Make a vactor of distances to test
Dist = sqrt(Results6(:,deltaE_Idx).^2 + Results6(:,MTF50_Idx).^2);

for NumIdx = 1:1:size(FindValues,1),
    Val = sqrt(FindValues(NumIdx,1).^2 + FindValues(NumIdx,2).^2);
    Rows = find(abs(Dist - Val) <= Tol);
    FindIdx = [FindIdx ; Rows];
end

FindIdx
Results6(FindIdx,:)

% Save the names of te parameters that we are changing
sensorSettings_Names = {'Width1','Width2','Width3','Width4','Width5','Width6','Pos1','Pos2','Pos3','Pos4','Pos5','Pos6'};
sensorSettings = Results6(FindIdx,1:2*numSensors);
save('SensorData6.mat', 'sensorSettings_Names', 'sensorSettings');

NumRows = size(sensorSettings,1);       % Number of different sensors that we're running
colorMetrics = zeros(NumRows,1);        % Initialize vector to save color metrics            
noiseMetrics = zeros(NumRows,1);        % Initialize vector to save noise metrics
frequencyMetrics = zeros(NumRows,1);    % Initialize vector to save frequency metrics

sensorIndex = 1;
analysisIndex = 1;
save('SavedData6.mat','colorMetrics','noiseMetrics','frequencyMetrics','sensorIndex','analysisIndex');

% Loop through all the sensors
Simulate6_Sub;

% Put the results into a matrix that we can save
%--------------------------------------------------------
ResultNames6 = sensorSettings_Names;
Results6 = sensorSettings;

Results6 = [Results6 colorMetrics frequencyMetrics noiseMetrics]; 
ResultNames6 = {ResultNames6{:},'deltaE','MTF50','yNoise'};

% Display the results
disp(ResultNames6);
disp(Results6);

% Save the final results
save('Results_6_Selected.mat', 'ResultNames6', 'Results6');

% Plot the final results
colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
figure(1);
plot(frequencyMetrics, colorMetrics, 'bo','MarkerFaceColor','b');
xlabel('MTF-50');
ylabel('Average \Delta E');
title('\bfColor Accuracy vs Frequency Accuracy, 6 colors');
grid on;
axis([0 max(1.1*frequencyMetrics) 0 max(1.1*colorMetrics)]);

saveas(gcf, ['./Images/Results_6_Selected.eps'],'epsc2');
saveas(gcf, ['./Images/Results_6_Selected.png']);





